function [B varargout] = subsref(A,S)
%SUBSREF Overload subsetting operations

% Overload subsetting operation so that we can index this object
% just like a matrix, using cell names as indices

switch(S.type)
    case '()'
        if numel(S.subs) ~= 2, error('subsetting AdjacencyMatrix requires two arguments'),end
        if ~(ischar(S.subs{1}) && ischar(S.subs{2}))
            throw(MException('AdjacencyMatrix:Subsetting','AdjacencyMatrix object must be subsetted using neuron names, or '':'''));
        end
        
        % If either index is ':' then the user wants an entire
        % row or column of the adjacency matrix.  In this case
        % we return a struct giving the cell names and values
        % of the weights
        
        rowStruct = false;
        columnStruct = false;
        
        if (strcmp(S.subs{1},':') && strcmp(S.subs{2},':'))
            showConnections(A);
            return
        end
        
        
        if (strcmp(S.subs{1},':'))
            columnStruct= true;
        elseif (strcmp(S.subs{2},':'))
            rowStruct = true;
        end
        
        % we are only interested in a particular row if this is
        % we are indexing a particular row
        if(~columnStruct)
            rowIdx = strcmp({A.cells.name},S.subs{1});
            
            if ~any(rowIdx)
                throw(MException('AdjacencyMatrix:Subsetting',['Could not find presynaptic cell ''' S.subs{1} '''']));
            end
            row = A.cells(rowIdx).rowNumber;
            if row == 0
                B = 0;
                return
                
            end
        end
        
        if(~rowStruct)
            columnIdx = strcmp({A.cells.name},S.subs{2});
            if ~any(columnIdx)
                throw(MException('AdjacencyMatrix:Subsetting',['Could not find postsynaptic cell ''' S.subs{2} '''']));
            end
            column = A.cells(columnIdx).columnNumber;
            
            if column == 0
                B = 0;
                return
            end
        end
        
        if rowStruct
            B = struct('target',A.columnLabels,'weight',num2cell(full(A.A(row,:))));
            fprintf('Presynaptic neuron: %s\n',S.subs{1});
            fprintf('%-12s\t%s\n','target','weight');
            for i = 1:numel(B)
                if B(i).weight ~= 0
                    fprintf('%-12s\t%i\n',B(i).target,B(i).weight);
                end
            end
            
            
        elseif columnStruct
            B = struct('source',A.rowLabels,'weight',num2cell(full(A.A(:,column))));
            fprintf('Postsynaptic neuron: %s\n',S.subs{1});
            fprintf('source\tweight\n');
            for i = 1:numel(B)
                if B(i).weight ~= 0
                    fprintf('%-12s\t%i\n',B(i).source,B(i).weight);
                end
            end
            
        else
            B = full(A.A(row,column));
        end
        
    case '.'
        switch(S.subs)
            case 'cells'
                B = {A.cells.name}';
            case 'A'
                
                
                
                B = A.A;
                varargout{1} = A.rowLabels;
                varargout{2} = A.columnLabels;
            otherwise
                error('AdjacencyMatrix:Subsetting','Operation not recognized');
                
        end
    otherwise
        error('AdjacencyMatrix:SubSetting','Operation not recognized');
end

end

